function y = binopdf(x,n,p)
% Faster version of BINOPDF Binomial probability density function.
%   Y = BINOPDF(X,N,P) returns the binomial probability density 

n = n(:,ones(n+1,1));
p = p(:,ones(n+1,1));

% Initialize Y to zero.
y = zeros(size(x));
 
% Binomial distribution is defined on positive integers less than N.
k = x+1;
nk = gammaln(n(k) + 1) - gammaln(x(k) + 1) - gammaln(n(k) - x(k) + 1);
lny = nk + x(k).*log( p(k)) + (n(k) - x(k)).*log(1 - p(k));
y(k) = exp(lny);